#!/bin/sh

# 4D client self upgradeable script

# parameters 1 old application folder 
# 2 application name (build name, different from $8 if the user changed the application name)
# 3 decompressing folder
# 4 temporary folder
# 5 trash  
# 6 script name  
# 7 old client process id   
# 8 application name (old application name, name choosed by the user)   

LOG_FILE="/$HOME/4Dupdatedebug.log"

if [ -e "$LOG_FILE" ]; then
	echo "\n\nDebugging on `date`" >> $LOG_FILE
fi

if [  -e  "$LOG_FILE" ] ; then echo `pwd` >> "$LOG_FILE" ; fi
if [  -e  "$LOG_FILE" ] ; then echo "P1:\"$1\" P2:\"$2\" P3:\"$3\" P4:\"$4\" P5:\"$5\" P6:\"$6\" P7:\"$7\" P8:\"$8\" P9:\"$9\"" >> "$LOG_FILE" ; fi


sa=".app"
appname=$2

if [ -n "$8" ] ; then
   oldname=$8
 else
   oldname=$2
fi

if [  -e  "$LOG_FILE" ] ; then echo "Start Waiting ID:$7" >> $LOG_FILE ; fi
# waiting old client to quit
count=`ps -p $7 | wc -l`
j=""
while [[ $count -gt 1 ]] && [[ $j -lt 30 ]] ; do
    sleep 0.2
    count=`ps -p $7 | wc -l`
    j=$(($j+1))
done
if [  -e  "$LOG_FILE" ] ; then echo "End Waiting ID:$7 Count:$count" >> $LOG_FILE ; fi

if [ $count -le 1 ] ; then 
  #Restore server settings
  R_server="Contents/Database/"
  F_server="EnginedServer.4Dlink"
  if [  -e  "$LOG_FILE" ] ; then echo "Test Existing $oldname$sa/${R_server}${F_server}" >> $LOG_FILE ; fi
  if [ -e "$oldname$sa/${R_server}${F_server}" ] ; then
    if [  -e  "$LOG_FILE" ] ; then echo "Copy $oldname$sa/${R_server}${F_server} in \"./$4/\" " >> $LOG_FILE ; fi
 	cp -f "./$oldname$sa/${R_server}${F_server}" "./$4/"
    CR=$?
    if [  -e  "$LOG_FILE" ] ; then echo "CodeRetour:$CR" >> $LOG_FILE ; fi
  	BFicLink=1
  else 
  	BFicLink=0
  fi

  # moving old client to trash
  # there is already in the trash an item (a folder or a file) with our client's name? 
  if [  -e  ~/.Trash/"$oldname$sa" ] ; then 
    i=""
    sc="copy"

    # looking for a name like our_clientXXX that is not already in the trash 
    while [  -e  ~/.Trash/"$oldname $sc $i$sa" ] ; do
      i=$(($i+1))
    done

    if [  -e  "$LOG_FILE" ] ; then echo "Move old application in ~/.Trash/$oldname $sc $i$sa" >> $LOG_FILE ; fi
  	mv "$oldname$sa" ~/.Trash/"$oldname $sc $i$sa"
  	CR=$?
    if [  -e  "$LOG_FILE" ] ; then echo "CodeRetour Move Old:$CR" >> $LOG_FILE ; fi
  else
    if [  -e  "$LOG_FILE" ] ; then echo "Move old application \"$oldname$sa\" in \"~/.Trash/$oldname$sa\"" >> $LOG_FILE ; fi
  	mv "$oldname$sa" ~/.Trash/"$oldname$sa"
    CR=$?
    if [  -e  "$LOG_FILE" ] ; then echo "CodeRetour Move Old:$CR" >> $LOG_FILE ; fi
  fi
  
  #new client replace the old one
  if [  -e  "$LOG_FILE" ] ; then echo "Move new application \"$4/$3/$appname$sa\" in \"$oldname$sa\"" >> $LOG_FILE ; fi
  mv "$4/$3/$appname$sa" "$oldname$sa"
  CR=$?
  if [  -e  "$LOG_FILE" ] ; then echo "CodeRetour Move New:$CR" >> $LOG_FILE ; fi
  
  if [ $count -le 1 ] ; then
  	if [  -e  "$LOG_FILE" ] ; then echo "Creat Directory and Move 4DLink \"$4/$F_server\" in \"$oldname$sa/${R_server}${F_server}\"" >> $LOG_FILE ; fi
  	mkdir -p "$oldname$sa/${R_server}"
  	CR=$?
    if [  -e  "$LOG_FILE" ] ; then echo "mkdir -p $oldname$sa/${R_server} status: $CR" >> "$LOG_FILE" ; fi
  	mv "./$4/$F_server" "$oldname$sa/${R_server}"
  	CR=$?
  	if [  -e  "$LOG_FILE" ] ; then echo "CodeRetour Move 4DLink:$CR" >> $LOG_FILE ; fi
  fi
   
  # temporary folder removing
  if [  -e  "$LOG_FILE" ] ; then echo "Deleted temporary folder $4" >> $LOG_FILE ; fi
  rm -dfR "$4"
  CR=$?
  if [  -e  "$LOG_FILE" ] ; then echo "CodeRetour Remove:$CR" >> $LOG_FILE ; fi
  
  # script removing from 4D Extensions
  # rm  -f   "$oldname$sa/Contents/4D Extensions/$6"

  # new client executable execute permissions
  if [  -e  "$LOG_FILE" ] ; then echo "New client executable execute permissions" >> $LOG_FILE ; fi
  chmod a+x "./$oldname$sa/Contents/MacOS/"*
  
  # new client launching
  if [  -e  "$LOG_FILE" ] ; then echo "New client launching" >> $LOG_FILE ; fi
  open "./$oldname$sa"

fi

